%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% file: exampleIntensities.m                                              %
%                                                                         %
% brief: This is an example for getting a intensity stream.               %
% note: The intensity output format is not supported by all devices.      %
%       Please refer to the software user manual of your device.          %
%                                                                         %
% autor: Benedikt Radl                                                    %
%                                                                         %
% Copyright (c) 2015 Bluetechnix Group GmbH                               %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

% get API version
[status, version, buildDateTime, supportedDeviceTypes] = BTAgetVersion;
if status ~= 0
    error('BTAgetVersion failed. See "status" for error description');
end

% get a config structure
[status, configStruct] = BTAinitConfig;
if status ~= 0
    error('BTAinitConfig failed. See "status" for error description');
end

% fill the config struct
configStruct.frameMode = 8;
configStruct.serialNumber = 0;
configStruct.deviceType = 2; %USB generic

% open device
[status, deviceHandle] = BTAopen(configStruct);
if status ~= 0
    error('BTAopen failed. See "status" for error description');
end


% get one frame
[status, frameHandle, frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAgetFrame failed. See "status" for error description');
end

% get intensities
[status, intensities, integrationTime, modulationFrequency, unit] = BTAgetIntensities(frameHandle);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAgetDistances failed. See "status" for error description');
end

% free frame
[status] = BTAfreeFrame(frameHandle);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAfreeFrame failed. See "status" for error description');
end

%create window for distances
figure('name','Intensities');
set(gcf,'NumberTitle','off')
%set color range from 0 to 5000
clims  = [0 5000];
hInt = imagesc(intensities, clims);
colorbar;
colormap('GRAY');

global MK;
MK=0;
set(gcf,'KeyPressFcn','MK=1;');

intWindowIsclosed = 0;

%loop 
while ~MK && ~(intWindowIsclosed)
    % get one frame
    [status, frameHandle,  frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
    if status == 0
        %get intensities
        [status, intensities, integrationTime, modulationFrequency, unit] = BTAgetIntensities(frameHandle);
        if status == 0
            if ishandle(hInt)
                %display distances
                set(hInt,'CData',intensities);
                refreshdata(hInt);
            else
                intWindowIsclosed = 1;
            end
        end
       
        %free frame
        [status] = BTAfreeFrame(frameHandle);
        if status ~= 0
            error('BTAfreeFrame failed. See "status" for error description');
        end
    end
    pause(0.001); 
end

%close device
status = BTAclose(deviceHandle);
if status ~= 0
	error('BTAclose failed. See "status" for error description');
end

close all;
clear all;


